 ; Contains the scale and rotate code for inserting a block to match the tb.
 ; Ŀ
 ;   Xnames - update the block Xrefname to show the names of all           
 ;   referenced xref definitions in the block tables.                      
 ;   Copyright 1997, 1998, 2000 by Rocket Software                         
 ;   Technology - fun stuff you could do if you didn't have more sense.    
 ; 

 ; Ŀ
 ;   Subroutine Xin - Insert the Xrefname block.                           
 ;   Takes one arguments, a text string.                                   
 ;   Returns T if a block was inserted, else nil.                          
 ;   Currently supports only Gemini title blocks.                          
 ; 
 (DEFUN XIN (str / ss ds pa dsxp dsyp wasins)
 ; Ŀ
 ;   Gemini.                                                               
 ; 
  (cond ((setq ss (ssget "X" (list (cons 2 "GELTITLE"))))
         (lam)
         (setq pa (cdr (assoc 10 (setq entt (entget (ssname ss 0))))))
         (setq ds (cdr (assoc 41 entt)))
         (setq dsxp (+ (car pa) (* 0 ds)))
         (setq dsyp (+ (cadr pa) (* 47 ds)))
         (command "insert" "xrefname" (list dsxp dsyp) ds "" "" str)
         (setq wasins T))
        ((setq ss (ssget "X" (list (cons 2 "GEIELCTB"))))
         (lam)
         (setq pa (cdr (assoc 10 (setq entt (entget (ssname ss 0))))))
         (setq ds (cdr (assoc 41 entt)))
         (setq rota (cdr (assoc 50 entt)))
         (setq dsxp (+ (car pa) (* 0 ds)))
         (setq dsyp (+ (cadr pa) (* 59 ds)))
         (setq dist (distance pa (setq pb (list dsxp dsyp))))
         (setq angg (angle pa pb))
         (setq pint (polar pa (+ rota angg) dist))
         (command "insert" "xrefname" pint ds "" (* 180 (/ rota pi)) str)
         (setq wasins T)))
 wasins)
 ; Ŀ
 ;   Xin end.                                                              
 ; 

 ; Ŀ
 ;   Contx - Find all referenced xref definitions in the block tables.     
 ;   Takes no arguments.                                                   
 ;   Returns a list of lists: ((Blockname Filename)...)                    
 ; 
 (DEFUN CONTX (/ rew bldat sevnt namlst)
  (setq rew t)
  (while (setq bldat (tblnext "block" rew))
         (setq rew ())
         (setq sevnt (cdr (assoc 70 bldat)))
         (if (and (= 4 (logand 4 sevnt)) (= 32 (logand 32 sevnt)))
             (setq namlst (append namlst (list (list (cdr (assoc 2 bldat))
                                                   (cdr (assoc 1 bldat))))))))
 namlst)
 ; Ŀ
 ;   Contx end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Lam - find or make a titleblock layer.                     
 ;   There are a variety of these, so this routine arbitrarily selects     
 ;   Tblock or Titleblock, with preference given to Tblock.                
 ;   Lam doesn't claim to be smarter than the user, having only seven      
 ;   lines of code.  Human equivalence takes nine.                         
 ; 
 (DEFUN LAM ()
  (cond ((tblsearch "layer" "tblock")
         (command "layer" "s" "tblock" ""))
        ((tblsearch "layer" "titleblock")
         (command "layer" "s" "titleblock" ""))
        (t (command "layer" "m" "tblock" "")))
 (princ))
 ; Ŀ
 ;   Lam end.                                                              
 ; 

 ; Ŀ
 ;   Xnames.                                                               
 ; 
 (DEFUN C:XNAMES (/ xlst xstr sub ss num enam entt)
  (setvar "cmdecho" 0)
  (setq xlst (contx))
  (while (setq sub (cadar xlst))
         (setq sub (strcase sub))
         (setq xlst (cdr xlst))
         (if xstr
            (setq xstr (strcat xstr ", " sub))
            (setq xstr (strcat "Xrefs: " sub))))
  (if (and xstr (null (setq ss (ssget "X" '((2 . "xrefname"))))))
      (if (xin xstr)
          (prompt "\n** Xref name block inserted. **\n")
          (prompt "\n** Caution: can't insert Xref name block. **\n"))
      (if xstr
          (progn
               (setq num 0)
               (while (and ss (setq enam (ssname ss num)))
                      (setq num (1+ num))
                      (setq entt (entget (entnext enam)))
                      (entmod (subst (cons 1 xstr) (assoc 1 entt) entt))
                      (entupd enam)))))
 (princ))